using System; 
 using System.Collections.Generic; 
 using System.ComponentModel; using System.Data; 
 using System.Drawing; 
 using System.Linq; 
 using System.Text; using System.Windows.Forms; 
using System.Threading;
using PsgBase;
using Model;

namespace Products
{
    [EditorClass, ViewGrid]
    public partial class Products : BaseEntity
    {
        #region Members / Constructors

        ProductsDS ds = new ProductsDS();
        ProductsDS.ProductsDataTable table = new ProductsDS.ProductsDataTable();
        ProductsDS.ProductsRow rowA = null;

        public Products()
        {
            InitializeComponent();
        }
        public Products(ViewGrid _browser):base(_browser)
        {
            InitializeComponent();
        }
        public Products(LookupGrid _search):base(_search)
        {
            InitializeComponent();
        }

        #endregion Constructors

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);

            context.PsgFieldKey = "id";
            context.PsgFieldDisplay = "name";
            context.PsgCommand = "products";
            context.PsgServerTableName = "products";
        }

        public override void PsgView()
        {
            base.PsgView();

            this.ColumnsView(table.nameColumn, "Product");
            this.ColumnsView(table.unitpriceColumn, "Unit price");

            this.FiltersView(table.nameColumn, "Product");
            this.FiltersView(table.unitpriceColumn, "Unit price");
        }

        public override void PsgStart()
        {
            base.PsgStart();

            AddService("products", ID);
            RunServices(this);           
        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);
            switch (this.alias_name.ToUpper())
            {
                case "PRODUCTS":
                    this.BeforeSetMainData(table);

                    ds.ReadXml(this.serializedDataFile);
                    table = ds.Products;

                    if (table.Rows.Count > 0)
                        rowA = (ProductsDS.ProductsRow)table.Rows[0];

                    this.AfterSetMainData(table);
                    break;
            }
        }

        public override void PsgBind()
        {
            BindEdit(edName, table.nameColumn);
            BindEdit(edUnitPrice, table.unitpriceColumn);
            BindEdit(edDescription, table.descriptionColumn);

            base.PsgBind();
        }

        public override void PsgSaveEntity()
        {
            base.BeforeSaveEntity();
            SaveDataSet("products", table.DataSet);

            base.PsgSaveEntity();
        }
    }
}